<?php
// DISPLAY ALL ERRORS
//error_reporting(E_ALL);
ini_set('display_errors', 0);
date_default_timezone_set('Asia/Bangkok');
// START & CONFIG
ob_start();
require 'setup/config.php';
session_start();
$LANG =  'cn';
// SET LANGUAGE
if (isset($_GET['lang'])){	
	$_SESSION['HTTP_ACCEPT_LANGUAGE'] = $_GET['lang'];
}
if (isset($_SESSION['HTTP_ACCEPT_LANGUAGE']) and file_exists('lang/' . $_SESSION['HTTP_ACCEPT_LANGUAGE'] . '.php')) {	
	if((@include 'lang/' . $_SESSION['HTTP_ACCEPT_LANGUAGE'] . '.php') === false){
		echo 'Caught exception: Translate file is wrong';
	}else{
		@include_once('lang/' . $_SESSION['HTTP_ACCEPT_LANGUAGE'] . '.php');
	}
} else {
	if((@include 'lang/' . $LANG . '.php') === false){
		echo 'Caught exception: Translate file is wrong';
	}else{
		@include_once('lang/' . $LANG . '.php');
	}
}


// INI VARs
$found = 0;                     // MARKER HOW MANY HITS FOUND A SEARCH
$done = 0;                     // MARKER HOW MANY ENTRYs ARE DONE
$msg = '';                    // TOAST MESSAGE
$file = 'data/Currency.json'; // DATA FILE NAME
// LOGIN CHECK

$login = check_current_user_login($ARR_USERS, $SALT);
$currentuser = $login['user'];
//var_dump($login);
if ($login['status'] == 200) {
    if($currentuser->gm  != '1' && $currentuser->changedcurrency  != '1'){
		header('location: index.php');exit;
	}
} else {
    header('location: login.php');
    exit;
}
// DELETE ENTRY IF DEL LINK IS CLICKED
if (@$_GET['delete_id'] != '') {
    $data = json_decode(file_get_contents($file), true);
    
    foreach ( $data as $key => $r  ){
        if($r['id'] == @$_GET['delete_id']){
            unset($data[$key]);
        }
    }    
    $convert_array_to_json = array_values($data);
    $write_json = json_encode($convert_array_to_json);
    file_put_contents($file, $write_json);
    header('location: currency.php?msg=' . $i18n['Entry successfully deleted.']);
    
}

// READ DATA
$user = json_decode(file_get_contents('data/User.json'));
$data = json_decode(file_get_contents($file), true);

$jsoncurent = json_decode(file_get_contents('currency/'.date('Ymd')),true);

$haschange = 0;
foreach ($data as $key => $values) { 
   if($values['currency'] == 'USDRMB' || $values['currency'] == 'USD*RMB'){
	   $values['currency'] = 'USD*RMB';
	   $exchangeratebydate = number_format((1/$jsoncurent['VND'])*$jsoncurent['USD'],0);
	   //echo 'exchangeratebydate='.$exchangeratebydate.'|exchangerate='.$values['exchangerate'];
	   if(number_format((float)$values['exchangerate'],0) != $exchangeratebydate){
		   $values['exchangerate'] = str_replace(',','',$exchangeratebydate);
		   $haschange = 1;
		   $data[$key] = $values;
	   }
   }
}
//echo '<pre>haschange='.$haschange; print_r($data);die();
if($haschange){
	file_put_contents($file, json_encode($data));
	$data = json_decode(file_get_contents($file), true);
}
//echo '<pre>'; print_r($jsoncurent); die();


if ($_SERVER['REQUEST_METHOD'] == 'POST' && $_POST['name'] != ''  ) {
	$id = time();
	if($_POST['id'] == ''){	
   	
        $formdata = array(
        'id' => $id	
		, 'currency' => $_POST['currency']
        , 'name' => $_POST['name']
        , 'exchangerate' => $_POST['exchangerate']
		, 'default' => $_POST['default']
		
  	);
  	$arr_data = array();
    	if (file_exists($file)) {
        	$jsondata = file_get_contents($file);
        	$arr_data = json_decode($jsondata, true);
    	}
   	$arr_data[] = $formdata;

	}else{
		$arr_data = array();
    		if (file_exists($file)) {
        		$jsondata = file_get_contents($file);
        		$arr_data = json_decode($jsondata, true);
    		}
		foreach ($arr_data as $key => $r){
			if($r['id'] == $_POST['id']){
				
				$textlog = '----------------------'.date('Y-m-d H:i:s').' - '.$currentuser->name.'----------------------';
				
				$arr_data[$key]['currency'] = $_POST['currency'];
				$arr_data[$key]['name'] = $_POST['name'];
				if($_POST['currency'] == 'VND'){
					$arr_data[$key]['exchangerate'] = round(1/$_POST['exchangerate'],8);
					$jsoncurent['VND']	=  round(1/$_POST['exchangerate'],8);
				}elseif($_POST['currency'] == 'Baht'){
					$arr_data[$key]['exchangerate'] = round(1/$_POST['exchangerate'],5);
					$jsoncurent['THB']	=  round(1/$_POST['exchangerate'],5);
				}elseif($_POST['currency'] == 'USD'){
					$arr_data[$key]['exchangerate'] = $_POST['exchangerate'];	
					$jsoncurent['USD']	=  $_POST['exchangerate'];	
				}elseif($_POST['currency'] == 'USD2'){
					$arr_data[$key]['exchangerate'] = $_POST['exchangerate'];	
					$jsoncurent['USD2']	=  $_POST['exchangerate'];	
				}elseif($_POST['currency'] == 'USDVND'){
					$arr_data[$key]['exchangerate'] = $_POST['exchangerate'];	
					$jsoncurent['USDVND']	=  $_POST['exchangerate'];	
				}elseif($_POST['currency'] == 'HKD'){
					$arr_data[$key]['exchangerate'] = round(1/$_POST['exchangerate'],5);	
					$jsoncurent['HKD']	=  round(1/$_POST['exchangerate'],5);	
				}elseif($_POST['currency'] == 'HKDVND'){
					$arr_data[$key]['exchangerate'] = $_POST['exchangerate'];	
					$jsoncurent['HKDVND']	=  $_POST['exchangerate'];	
				}elseif($_POST['currency'] == 'USDHKD'){
					$arr_data[$key]['exchangerate'] = $_POST['exchangerate'];	
					$jsoncurent['USDHKD']	=  $_POST['exchangerate'];	
				}elseif($_POST['currency'] == 'MYR'){
					$arr_data[$key]['exchangerate'] = $_POST['exchangerate'];	
					$jsoncurent['MYR']	=  $_POST['exchangerate'];	
				}elseif($_POST['currency'] == 'IDR'){
					$arr_data[$key]['exchangerate'] = round(1/$_POST['exchangerate'],6);	
					$jsoncurent['IDR']	=  round(1/$_POST['exchangerate'],6);	
				}
				$arr_data[$key]['default'] = $_POST['default'];
				
				$textlog .= PHP_EOL.$arr_data[$key]['currency'].': '.$_POST['exchangerate'];
				file_put_contents('logs/'.$_POST['id'],file_get_contents('logs/'.$_POST['id']).$textlog.PHP_EOL);
			}
		}
	}
  
    $jsondata = json_encode($arr_data);
	
	file_put_contents('currency/'.date('Ymd'),json_encode($jsoncurent));

    if (file_put_contents($file, $jsondata)) {
        $msg = $i18n['Data successfully saved!'];
    } else {
        $msg = $i18n['ERROR &mdash; Data not saved!'];
    }
    header('location: currency.php?msg=' . $msg);
} else if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $_GET['msg'] = $i18n['All fields are required!'];
}

// CREATE DATA FILE IF NOT EXISTS
if (!is_file($file)) {
    file_put_contents($file, '');
}

// HEADER
ob_end_flush();
include 'tpl/header.php';
// FORM FOR NEW ENTRY
if(@$_GET['q'] == ''){
?>

<script>


function editc(id) {

var obj = jQuery.parseJSON(id);
$('#currency,#name,#exchangerate').next().addClass('active');

$('#id').val(obj.id);


$('#currency').val(obj.currency);
$('#name').val(obj.name);
$('#exchangerate').val(obj.exchangerate);
if(obj.default == 1){
$('#default').prop('checked',true);
}

}
        
</script>            


<div class="badge grey lighten-3 hoverable create-user">
            <form action="" method="POST">

 		<input value=""  id="id" name="id" type="hidden"  />
                <div class="row">
					<div class="input-field col s2">
                        <input 
                            value="" 
                            id="currency" 
                            name="currency" 
                            type="text" 
                            class="validate" 
                            maxlength="32" 
                            data-length="32" 
                            autocomplete="off"  />
                        <label for="receiverid">Currency symbol</label>
                        <span class="helper-text" data-error="Error" data-success="OK">
                           
                        </span>
                    </div> 
                    <div class="input-field col s2">
                        <input 
                            value="" 
                            id="name" 
                            name="name" 
                            type="text" 
                            class="validate" 
                            maxlength="32" 
                            data-length="32" 
                            required="required"  autocomplete="off"  />
                        <label for="name">货币名称</label>
                        <span class="helper-text" data-error="Error" data-success="OK">
                           Currency Name
                        </span>
                    </div> 
					<div class="input-field col s2">
                        <input 
                            value="" 
                            id="exchangerate" 
                            name="exchangerate" 
                            type="text"                           
                           autocomplete="off"  />
                        <label for="description">汇率</label>
                        <span class="helper-text" data-error="Error" data-success="OK">
                          Exchange rate to default currency
                        </span>
                    </div> 

					
                    <div class="input-field col s2" style="display:none;" >
						<label class="pure-material-checkbox">
						  <input type="checkbox"  value="1"  id="default"   name="default"  >
						  <span>Currency Default ?</span>
						</label>
                    </div> 

	
                    <div class="input-field col s1" style="    text-align: right;">
                        <button class="colortoptran btn waves-effect waves-light" type="submit" name="action">
                            Save
                        </button>
                    </div>
                    <div class="input-field col s1 ">
                        <a style="    background: #4e4e4e;" class="btn  btn-default waves-effect waves-light" href="./index.php">
                            <?php echo $i18n['Go Back']; ?>
                        </a>
                    </div>
                </div>
            </form>
        </div>
		<h2 style="text-align:center;font-size: 28px; " >每天下午4点钟系统自动保存汇率，请在这之前保证汇率的准确性</h2>
    <?php
}
// DATA TABLE
if (!empty($data)) {
    // LOOP EACH ENTRY
    ?>
        <table class="striped responsive-table hoverable tablesorter" id="tab-table">
            <thead>
                <tr>
					<th>Currency symbol</th>
                    <th>Currency Name</th>
                    <th>Exchange rate</th>                  
					<th  style="display:none;"  >Currency Default</th>			
					<th></th>
                </tr>
            </thead>
        <tbody>
   <?php 
     $total_receivable = $total_amount = $total_profit = 0;
     $countNo = 0;
        foreach ($data as $key => $values) { 
		     $toast = 'M.toast({html: "<span>' . $values['name'] . '</span>' .
                    '<a href=\"?delete_id=' . $values['id'] . '\" class=\"toast-action\">' .
                    $i18n['DELETE'] . '</a> &nbsp; &nbsp;"});';
					
					if ($currentuser->gm == '1' && file_exists("logs/".$values['id'])) {
						$logs = file_get_contents("logs/".$values['id']);
						$logs = str_replace(PHP_EOL,'<br>',$logs);
						$logsmode = '<a  href="#" data-target="modal6" class="modal-trigger cllogcontent" ><span style="display:none;" >'. $logs .'</span><i class="grey-text small material-icons">content_paste</i></a>';
					}else{
						$logsmode = '';
					}			
		
	            ?>    
                <tr>
					<td style="padding-left:20px"><?php echo ++$k; ?>. <?= $values['currency']?></td>
                    <td style="padding-left:20px"><?= $values['name']?></td>
                    <td style="padding-left:20px"><?php 
					if($values['currency'] == 'VND'){
						echo $VND = number_format((1/$values['exchangerate']),0);
						$values['exchangerate'] =  round(1/$values['exchangerate'],0);
					}elseif($values['currency'] == 'Baht'){
						echo $Baht = number_format((1/$values['exchangerate']),3);
						$values['exchangerate'] =  round(1/$values['exchangerate'],3);
					}elseif($values['currency'] == 'USD'){
						echo $USD = $values['exchangerate'];
					}elseif($values['currency'] == 'USD2'){
						echo $k3 = $USD = $values['exchangerate'];
					}elseif($values['currency'] == 'HKD'){
						echo $HKD = number_format((float)$values['exchangerate'],2);
						$values['exchangerate'] =  round($values['exchangerate'],2);
					}elseif($values['currency'] == 'MYR'){
						echo $MYR = $values['exchangerate'];
						
					}elseif($values['currency'] == 'IDR'){
						echo $IDR = number_format(1/$values['exchangerate'],0);
						
					}else{
                                          
						echo $USDVND = number_format((float)$values['exchangerate']);
					}
                                        
                                        if($values['currency'] == 'USDVND'){
                                          $k6 = $values['exchangerate'];
                                        }
					?></td>                   
					<td style="padding-left:20px;display:none;"    ><?= $values['default']?></td>
                    <td style="padding-left:20px">
						<?php  if($currentuser->gm == 1){ ?>						
                        <a class="tooltipped" data-position="top" data-tooltip="<?= $i18n['Click alert link for delete!']?>" href="#" onclick='<?php echo $toast; ?>' >
                            <i class="red-text text-darken-4 small material-icons">delete_forever</i>
                        </a>
						<?php } ?>
                        <a class="tooltipped" data-position="top" data-tooltip="<?= $i18n['EDIT'] ?>" href="#" onclick='editc("<?php echo addslashes(json_encode($values)); ?>")'>
                            <i class="grey-text small material-icons">mode_edit</i>
                        </a>
						<?php  if($currentuser->gm == 1){ ?>
						<?php echo $logsmode; ?>
						<?php } ?>
                    </td>
                </tr>
            <?php  }  ?>
                <tr>
                    <td style="padding-left:20px"><?php echo ++$k; ?>. Exchange</td>
                    <td style="padding-left:20px">RMB Exchange</td>
                    <td style="padding-left:20px"><?php echo number_format((1/$k3)*$k6,0); ?></td>                   
                    <td style="padding-left:20px;display:none;"    ><?= $values['default']?></td>
                    <td style="padding-left:20px">
						
                    </td>
                </tr>
        </tbody>
        </table>
    <?php
}
// ENDIF no data

    
 // ECHO PROGRESS-BAR (only if there is no search performed) SEE tpl/css/progress.css
if (@$_GET['q'] == '') {
    echo '<div class="progress tooltipped" data-position="top"' .
    ' data-tooltip="' . $done . '/' . count((array)$data) . ' ' . $TYPE .
    '" title="' . $done . '/' . count((array)$data) . ' ' . $TYPE . '">' .
    '<div class="progress-bar green" data-width="' . ($done / count((array)$data) * 100) .
    '" style="width:' . ($done / count((array)$data) * 100) . '%"></div></div>';
}
?>

<table style="width: 100%!important;position: relative; " class="striped responsive-table  tablesorter  "  >
  <thead>
		<tr>
			<?php for($i = 9; $i >= 0; $i--){ ?>
					<th style="text-align:center;" ><?php echo date('Y-m-d',strtotime("-".$i." day") ) ?></th>
			<?php } ?>
		</tr>
  </thead>
  <tbody>
		<tr>
			<?php for($i = 9; $i >= 0; $i--){
					$data = json_decode(file_get_contents('currency/'.date('Ymd',strtotime("-".$i." day"))))
				?>
					<td style="text-align:center;" >1 USD*RMB = <?php echo  round(1/($data->VND/$data->USD),0); ?> VND</td>
			<?php } ?>
		</tr>
		<tr>
			<?php for($i = 9; $i >= 0; $i--){
					$data = json_decode(file_get_contents('currency/'.date('Ymd',strtotime("-".$i." day"))));
			?>
					<td style="text-align:center;" >1 USD = <?php echo round($data->USD,4); ?> RMB</td>
			<?php } ?>
		</tr>
		<tr>
			<?php for($i = 9; $i >= 0; $i--){
					$data = json_decode(file_get_contents('currency/'.date('Ymd',strtotime("-".$i." day"))));
				?>
					<td style="text-align:center;" >1 RMB = <?php echo number_format(1/$data->VND); ?> VND</td>
			<?php } ?>
		</tr>
		<tr>
			<?php for($i = 9; $i >= 0; $i--){
					$data = json_decode(file_get_contents('currency/'.date('Ymd',strtotime("-".$i." day"))));
				?>
					<td style="text-align:center;" >1 RMB = <?php echo round(1/$data->THB,3); ?> Bath</td>
			<?php } ?>
		</tr>
		<tr>
			<?php for($i = 9; $i >= 0; $i--){
					$data = json_decode(file_get_contents('currency/'.date('Ymd',strtotime("-".$i." day"))));					
				?>
					<td style="text-align:center;" >1 USD = <?php echo $data->USDVND; ?> VND</td>
			<?php } ?>
		</tr>
		<!--<tr>
			<?php for($i = 9; $i >= 0; $i--){
					$data = json_decode(file_get_contents('currency/'.date('Ymd',strtotime("-".$i." day"))))
				?>
					<td style="text-align:center;" >1 USD = <?php echo  round($data->HKD,4); ?> HKD</td>
			<?php } ?>
		</tr>
		<tr>
			<?php for($i = 9; $i >= 0; $i--){
					$data = json_decode(file_get_contents('currency/'.date('Ymd',strtotime("-".$i." day"))));
					if($data->HKDVND <= 0){
						$data->USDVND = 0;
					}
					
				?>
					<td style="text-align:center;" >1 HKD = <?php echo $data->HKDVND; ?> VND</td>
			<?php } ?>
		</tr>-->
  </tbody>
</table>
<?php if ($currentuser->gm == "1"  ){ ?>	
<div id="modal6" class="modal">
  <div class="logcontent" style="padding: 15px;" ></div>
</div>
<?php } ?>
<!-- Resources -->
<script src="https://www.amcharts.com/lib/4/core.js"></script>
<script src="https://www.amcharts.com/lib/4/charts.js"></script>
<script src="https://www.amcharts.com/lib/4/themes/animated.js"></script>

<!-- Chart code -->
<script>
<?php if ($currentuser->gm == "1"  ){ ?>	
	$(".cllogcontent").click(function(){
		$(".logcontent").html($(this).find('span').html());
	});	
<?php } ?>        
am4core.ready(function() {

// Themes begin
am4core.useTheme(am4themes_animated);
// Themes end

// Create chart instance
var chart = am4core.create("chartdiv", am4charts.XYChart);
var chart2 = am4core.create("chartdiv2", am4charts.XYChart);
var chart3 = am4core.create("chartdiv3", am4charts.XYChart);
var chart4 = am4core.create("chartdiv4", am4charts.XYChart);
// Add data
chart.data = [ 
<?php 

if ($handle = opendir('currency')) {
    while (false !== ($entry = readdir($handle))) {
        if ($entry != "." && $entry != "..") {
			$data =  json_decode(file_get_contents('currency/'.$entry));
			$adata[$entry] = $data;
		}
    }
    closedir($handle);
}	
		
ksort($adata);	
			foreach ($adata as $key => $r){
                            if($key == 0){
                                continue;
                            }
                            
           ?>
				{
				  "date": "<?php echo date('Y-m-d',strtotime($key)); ?>",
				  "value": <?php if($r->USD > 0){echo $r->USD; $jshd = $r->USD;}else{ echo $jshd; } ?>
				},
		   <?php
			}
?>

];

// Add data
chart2.data = [ 
<?php 
			foreach ($adata as $key => $r){
			 if($key == 0){
                                continue;
                            }
           ?>
				{
				  "date": "<?php echo date('Y-m-d',strtotime($key)); ?>",
				  "value": <?php if($r->THB > 0){echo 1/$r->THB; $jshd = 1/$r->THB; }else{ echo $jshd;} ?>
				},
		   <?php
        }
   
?>

];

// Add data
chart3.data = [ 
<?php 

	foreach ($adata as $key => $r){
             if($key == 0){
                                continue;
                            }
           ?>
				{
				  "date": "<?php echo date('Y-m-d',strtotime($key)); ?>",
				  "value": <?php if($r->VND > 0){echo 1/$r->VND; $jshd = 1/$r->VND; }else{ echo $jshd;} ?>
				},
		   <?php
	}
?>

];

// Add data
chart4.data = [ 
<?php 

	foreach ($adata as $key => $r){
             if($key == 0){
                                continue;
                            }
		if($r->USDVND <= 0){$r->USDVND = 0;}
           ?>
				{
				  "date": "<?php echo date('Y-m-d',strtotime($key)); ?>",
				  "value": <?php if($r->USDVND > 0){echo $r->USDVND; $jshd = $r->USDVND; }else{ echo $jshd; } ?>
				},
		   <?php
	}
?>

];



// Create axes
var dateAxis = chart.xAxes.push(new am4charts.DateAxis());
dateAxis.renderer.grid.template.location = 0;
dateAxis.renderer.minGridDistance = 50;

var valueAxis = chart.yAxes.push(new am4charts.ValueAxis());

// Create series
var series = chart.series.push(new am4charts.LineSeries());
series.dataFields.valueY = "value";
series.dataFields.dateX = "date";
series.strokeWidth = 3;
series.fillOpacity = 0.5;

// Add vertical scrollbar
chart.scrollbarY = new am4core.Scrollbar();
chart.scrollbarY.marginLeft = 0;

// Add cursor
chart.cursor = new am4charts.XYCursor();
chart.cursor.behavior = "zoomY";
chart.cursor.lineX.disabled = true;

chart.scrollbarX = new am4charts.XYChartScrollbar();
chart.scrollbarX.series.push(series);
chart.scrollbarX.parent = chart.bottomAxesContainer;
chart.events.on("ready", function () {
  dateAxis.zoom({start:0.8, end:1});
});



////////////
// Create axes
var dateAxis2 = chart2.xAxes.push(new am4charts.DateAxis());
dateAxis2.renderer.grid.template.location = 0;
dateAxis2.renderer.minGridDistance = 50;

var valueAxis2 = chart2.yAxes.push(new am4charts.ValueAxis());

// Create series
var series2 = chart2.series.push(new am4charts.LineSeries());
series2.dataFields.valueY = "value";
series2.dataFields.dateX = "date";
series2.strokeWidth = 3;
series2.fillOpacity = 0.5;

// Add vertical scrollbar
chart2.scrollbarY = new am4core.Scrollbar();
chart2.scrollbarY.marginLeft = 0;

// Add cursor
chart2.cursor = new am4charts.XYCursor();
chart2.cursor.behavior = "zoomY";
chart2.cursor.lineX.disabled = true;


chart2.scrollbarX = new am4charts.XYChartScrollbar();
chart2.scrollbarX.series.push(series2);
chart2.scrollbarX.parent = chart2.bottomAxesContainer;
chart2.events.on("ready", function () {
  dateAxis2.zoom({start:0.8, end:1});
});

//////////////
// Create axes
var dateAxis3 = chart3.xAxes.push(new am4charts.DateAxis());
dateAxis3.renderer.grid.template.location = 0;
dateAxis3.renderer.minGridDistance = 50;

var valueAxis3 = chart3.yAxes.push(new am4charts.ValueAxis());

// Create series
var series3 = chart3.series.push(new am4charts.LineSeries());
series3.dataFields.valueY = "value";
series3.dataFields.dateX = "date";
series3.strokeWidth = 3;
series3.fillOpacity = 0.5;

// Add vertical scrollbar
chart3.scrollbarY = new am4core.Scrollbar();
chart3.scrollbarY.marginLeft = 0;

// Add cursor
chart3.cursor = new am4charts.XYCursor();
chart3.cursor.behavior = "zoomY";
chart3.cursor.lineX.disabled = true;

chart3.scrollbarX = new am4charts.XYChartScrollbar();
chart3.scrollbarX.series.push(series3);
chart3.scrollbarX.parent = chart3.bottomAxesContainer;
chart3.events.on("ready", function () {
  dateAxis3.zoom({start:0.8, end:1});
});

//////////////
// Create axes
var dateAxis4 = chart4.xAxes.push(new am4charts.DateAxis());
dateAxis4.renderer.grid.template.location = 0;
dateAxis4.renderer.minGridDistance = 50;

var valueAxis4 = chart4.yAxes.push(new am4charts.ValueAxis());
// Create series
var series4 = chart4.series.push(new am4charts.LineSeries());
series4.dataFields.valueY = "value";
series4.dataFields.dateX = "date";
series4.strokeWidth = 3;
series4.fillOpacity = 0.5;

// Add vertical scrollbar
chart4.scrollbarY = new am4core.Scrollbar();
chart4.scrollbarY.marginLeft = 0;

// Add cursor
chart4.cursor = new am4charts.XYCursor();
chart4.cursor.behavior = "zoomY";
chart4.cursor.lineX.disabled = true;

chart4.scrollbarX = new am4charts.XYChartScrollbar();
chart4.scrollbarX.series.push(series4);
chart4.scrollbarX.parent = chart4.bottomAxesContainer;
chart4.events.on("ready", function () {
  dateAxis4.zoom({start:0.8, end:1});
});



let title = chart.titles.create();
title.text = "USD to RMB <?php echo $USD; ?>";
title.fontSize = 25;
title.marginBottom = 30;

let title2 = chart2.titles.create();
title2.text = "RMB to Bath <?php echo $Baht; ?>";
title2.fontSize = 25;
title2.marginBottom = 30;

let title3 = chart3.titles.create();
title3.text = "RMB to VND <?php echo $VND; ?> ";
title3.fontSize = 25;
title3.marginBottom = 30;

let title4 = chart4.titles.create();
title4.text = "USD to VND <?php echo $USDVND; ?> ";
title4.fontSize = 25;
title4.marginBottom = 30;

}); // end am4core.ready()
</script>
<style>
#chartdiv , #chartdiv2 , #chartdiv3 , #chartdiv4 {
  width: 50%;
  height: 400px;float:left;
}

</style>

<!-- HTML -->
<div id="chartdiv" ></div>
<div id="chartdiv2" ></div>
<div id="chartdiv3" ></div>
<div id="chartdiv4" ></div>
<?php
// var_dump($sortdate); die;
// FOOTER
include 'tpl/footer.php';
?>
